from insights.core.spec_factory import SpecSet, RegistryPoint


class Specs(SpecSet):
    # Client metadata specs/files
    ansible_host = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    blacklist_report = RegistryPoint(prio=-1)
    blacklisted_specs = RegistryPoint(no_obfuscate=['hostname', 'ip'], prio=-1)
    branch_info = RegistryPoint()  # https://issues.redhat.com/browse/RHIN-639
    display_name = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    egg_release = RegistryPoint()
    tags = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    version_info = RegistryPoint(no_obfuscate=['hostname', 'ip'])

    # Client App specs
    compliance = RegistryPoint()
    compliance_policies = RegistryPoint()
    compliance_assign = RegistryPoint()
    compliance_unassign = RegistryPoint()
    malware_detection = RegistryPoint()

    # Regular collection specs
    abrt_ccpp_conf = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    abrt_status_bare = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    alternatives_display_python = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    amq_broker = RegistryPoint(multi_output=True)
    audit_log = RegistryPoint(filterable=True)
    auditctl_rules = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    auditctl_status = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    auditd_conf = RegistryPoint()
    audispd_conf = RegistryPoint()
    ausearch_insights_client = RegistryPoint(prio=-1)  # The last spec to collect
    authselect_current = RegistryPoint()
    autofs_conf = RegistryPoint()
    avc_cache_threshold = RegistryPoint()
    avc_hash_stats = RegistryPoint()
    aws_instance_id_doc = RegistryPoint()
    aws_instance_id_pkcs7 = RegistryPoint()
    aws_public_ipv4_addresses = RegistryPoint()
    aws_public_hostnames = RegistryPoint()
    awx_manage_check_license = RegistryPoint()
    awx_manage_check_license_data = RegistryPoint(filterable=True)
    awx_manage_print_settings = RegistryPoint()
    azure_instance_id = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    azure_instance_plan = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    azure_instance_type = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    azure_load_balancer = RegistryPoint()
    basic_auth_insights_client = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    bdi_read_ahead_kb = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    bios_uuid = RegistryPoint()
    blkid = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    bond = RegistryPoint(multi_output=True)
    bond_dynamic_lb = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    boot_loader_entries = RegistryPoint(multi_output=True)
    bootc_status = RegistryPoint(no_obfuscate=['hostname'])
    brctl_show = RegistryPoint()
    buddyinfo = RegistryPoint()
    candlepin_broker = RegistryPoint()
    candlepin_error_log = RegistryPoint(filterable=True)
    candlepin_log = RegistryPoint(filterable=True)
    catalina_out = RegistryPoint(multi_output=True, filterable=True)
    catalina_server_log = RegistryPoint(multi_output=True, filterable=True)
    cciss = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    cdc_wdm = RegistryPoint()
    ceilometer_central_log = RegistryPoint(filterable=True)
    ceilometer_collector_log = RegistryPoint(filterable=True)
    ceilometer_compute_log = RegistryPoint(filterable=True)
    ceilometer_conf = RegistryPoint()
    ceph_conf = RegistryPoint(filterable=True)
    ceph_config_show = RegistryPoint(multi_output=True)
    ceph_df_detail = RegistryPoint()
    ceph_health_detail = RegistryPoint()
    ceph_insights = RegistryPoint()
    ceph_log = RegistryPoint(multi_output=True, filterable=True)
    ceph_osd_df = RegistryPoint()
    ceph_osd_dump = RegistryPoint()
    ceph_osd_ec_profile_get = RegistryPoint(multi_output=True)
    ceph_osd_log = RegistryPoint(multi_output=True, filterable=True)
    ceph_osd_tree = RegistryPoint()
    ceph_osd_tree_text = RegistryPoint()
    ceph_report = RegistryPoint()
    ceph_s = RegistryPoint()
    ceph_v = RegistryPoint()
    certificates_enddate = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    cgroups = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    checkin_conf = RegistryPoint()
    chkconfig = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    chrony_conf = RegistryPoint()
    chronyc_sources = RegistryPoint()
    cib_xml = RegistryPoint()
    cifs_debug_data = RegistryPoint(filterable=True)
    cinder_api_log = RegistryPoint(filterable=True)
    cinder_conf = RegistryPoint()
    cinder_volume_log = RegistryPoint(filterable=True)
    cloud_cfg = RegistryPoint(filterable=True)
    cloud_cfg_filtered = RegistryPoint()
    cloud_init_query = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    cloud_init_custom_network = RegistryPoint()
    cloud_init_log = RegistryPoint(filterable=True)
    cluster_conf = RegistryPoint(filterable=True)
    cmdline = RegistryPoint()
    cni_podman_bridge_conf = RegistryPoint()
    cobbler_modules_conf = RegistryPoint()
    cobbler_settings = RegistryPoint()
    containers_policy = RegistryPoint()
    convert2rhel_facts = RegistryPoint()
    corosync = RegistryPoint(filterable=True)
    corosync_cmapctl = RegistryPoint(multi_output=True)
    corosync_conf = RegistryPoint()
    cpe = RegistryPoint()
    cpu_cores = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    cpu_siblings = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    cpu_smt_active = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    cpu_smt_control = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    cpu_vulns = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    cpuinfo = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    cpupower_frequency_info = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    cpuset_cpus = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    crictl_logs = RegistryPoint(multi_output=True, filterable=True)
    crio_conf = RegistryPoint(multi_output=True)
    cron_daily_rhsmd = RegistryPoint(filterable=True)
    cron_foreman = RegistryPoint(filterable=True)
    cron_log = RegistryPoint(filterable=True)
    crt = RegistryPoint()
    crypto_policies_bind = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    crypto_policies_config = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    crypto_policies_opensshserver = RegistryPoint()
    crypto_policies_state_current = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    cryptsetup_luksDump = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    cupsd_conf = RegistryPoint()
    cups_browsed_conf = RegistryPoint(filterable=True)
    cups_files_conf = RegistryPoint()
    cups_ppd = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    current_clocksource = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    date = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    date_utc = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    db2_database_configuration = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    db2_database_manager = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    db2ls_a_c = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    dcbtool_gc_dcb = RegistryPoint(multi_output=True)
    designate_conf = RegistryPoint(filterable=True)
    df__al = RegistryPoint()
    df__alP = RegistryPoint()
    df__li = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    dig = RegistryPoint()
    dig_dnssec = RegistryPoint()
    dig_edns = RegistryPoint()
    dig_noedns = RegistryPoint()
    dirsrv = RegistryPoint(filterable=True)
    dirsrv_access = RegistryPoint(multi_output=True, filterable=True)
    dirsrv_errors = RegistryPoint(multi_output=True, filterable=True)
    display_java = RegistryPoint()
    dm_mod_use_blk_mq = RegistryPoint()
    dmesg = RegistryPoint(filterable=True)
    dmesg_log = RegistryPoint(filterable=True)
    dmidecode = RegistryPoint()
    dmsetup_info = RegistryPoint()
    dmsetup_status = RegistryPoint()
    dnf_conf = RegistryPoint(filterable=True)
    dnf_module_info = RegistryPoint()
    dnf_module_list = RegistryPoint()
    dnf_modules = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    dnsmasq_config = RegistryPoint(multi_output=True)
    docker_container_inspect = RegistryPoint(multi_output=True)
    docker_host_machine_id = RegistryPoint()
    docker_info = RegistryPoint()
    docker_list_containers = RegistryPoint()
    docker_list_images = RegistryPoint()
    docker_storage = RegistryPoint(filterable=True)
    docker_storage_setup = RegistryPoint(filterable=True)
    docker_sysconfig = RegistryPoint(filterable=True)
    dotnet_version = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    doveconf = RegistryPoint(filterable=True)
    dracut_kdump_capture_service = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    dse_ldif = RegistryPoint(multi_output=True, filterable=True)
    du_dirs = RegistryPoint(multi_output=True, filterable=True, no_obfuscate=['hostname', 'ip'])
    dumpe2fs_h = RegistryPoint(multi_output=True)
    duplicate_machine_id = RegistryPoint(filterable=True)
    eap_json_reports = RegistryPoint(multi_output=True)
    engine_config_all = RegistryPoint()
    engine_db_query_vdsm_version = RegistryPoint()
    engine_log = RegistryPoint(filterable=True)
    etc_journald_conf = RegistryPoint()
    etc_journald_conf_d = RegistryPoint(multi_output=True)
    etc_machine_id = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    etc_udev_40_redhat_rules = RegistryPoint(filterable=True)
    etc_udev_oracle_asm_rules = RegistryPoint(multi_output=True, filterable=True)
    etcd_conf = RegistryPoint(filterable=True)
    ethtool = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ethtool_S = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ethtool_T = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ethtool_a = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ethtool_c = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ethtool_g = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ethtool_i = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ethtool_k = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    facter = RegistryPoint()
    falconctl_aid = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    falconctl_backend = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    falconctl_rfm = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    falconctl_version = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    fapolicyd_rules = RegistryPoint(
        multi_output=True, filterable=True, no_obfuscate=['hostname', 'ip']
    )
    fc_match = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    fcoeadm_i = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    findmnt_lo_propagation = RegistryPoint()
    firewall_cmd_list_all_zones = RegistryPoint()
    firewalld_conf = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    foreman_production_log = RegistryPoint(filterable=True)
    foreman_proxy_conf = RegistryPoint()
    foreman_proxy_log = RegistryPoint(filterable=True)
    foreman_rake_db_migrate_status = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    foreman_satellite_log = RegistryPoint(filterable=True)
    foreman_ssl_access_ssl_log = RegistryPoint(filterable=True)
    foreman_ssl_error_ssl_log = RegistryPoint(filterable=True)
    foreman_tasks_config = RegistryPoint(filterable=True)
    freeipa_healthcheck_log = RegistryPoint()
    fstab = RegistryPoint()
    fw_devices = RegistryPoint()
    fw_security = RegistryPoint()
    galera_cnf = RegistryPoint()
    gcp_instance_type = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    gcp_license_codes = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    gcp_network_interfaces = RegistryPoint()
    getcert_list = RegistryPoint()
    getconf_page_size = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    getenforce = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    getsebool = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    gfs2_file_system_block_size = RegistryPoint(multi_output=True)
    glance_api_log = RegistryPoint(filterable=True)
    gluster_peer_status = RegistryPoint()
    gluster_v_info = RegistryPoint()
    gluster_v_status = RegistryPoint()
    gnocchi_conf = RegistryPoint(filterable=True)
    gnocchi_metricd_log = RegistryPoint(filterable=True)
    greenboot_status = RegistryPoint(filterable=True)
    group_info = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    grub1_config_perms = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    grub2_cfg = RegistryPoint()
    grub2_efi_cfg = RegistryPoint()
    grub_conf = RegistryPoint()
    grub_config_perms = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    grub_efi_conf = RegistryPoint()
    grubby_default_index = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    grubby_default_kernel = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    grubenv = RegistryPoint()
    hammer_ping = RegistryPoint()
    hammer_task_list = RegistryPoint()
    haproxy_cfg = RegistryPoint()
    haproxy_cfg_scl = RegistryPoint()
    heat_api_log = RegistryPoint(filterable=True)
    heat_conf = RegistryPoint()
    heat_crontab = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    heat_engine_log = RegistryPoint(filterable=True)
    hostname = RegistryPoint(no_obfuscate=['ip'])
    hostname_default = RegistryPoint(no_obfuscate=['ip'])
    hostname_short = RegistryPoint(no_obfuscate=['ip'])
    hosts = RegistryPoint()
    hponcfg_g = RegistryPoint()
    httpd24_httpd_error_log = RegistryPoint(filterable=True)
    httpd_M = RegistryPoint(multi_output=True)
    httpd_V = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    httpd_access_log = RegistryPoint(filterable=True)
    httpd_cert_info_in_nss = RegistryPoint(multi_output=True, filterable=True, no_obfuscate=['ip'])
    httpd_conf = RegistryPoint(multi_output=True)
    httpd_conf_scl_httpd24 = RegistryPoint(multi_output=True)
    httpd_conf_scl_jbcs_httpd24 = RegistryPoint(multi_output=True)
    httpd_error_log = RegistryPoint(filterable=True)
    httpd_limits = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    httpd_on_nfs = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    httpd_ssl_access_log = RegistryPoint(filterable=True)
    httpd_ssl_cert_enddate = RegistryPoint(multi_output=True, no_obfuscate=['ip'])
    httpd_ssl_error_log = RegistryPoint(filterable=True)
    ibm_fw_vernum_encoded = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ibm_lparcfg = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    ifcfg = RegistryPoint(multi_output=True)
    ifcfg_static_route = RegistryPoint(filterable=True, multi_output=True)
    ilab_model_list = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    imagemagick_policy = RegistryPoint(multi_output=True, filterable=True, no_obfuscate=['ip'])
    image_builder_facts = RegistryPoint()
    init_ora = RegistryPoint()
    init_process_cgroup = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    initctl_lst = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    initscript = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    insights_client_conf = RegistryPoint(filterable=True)
    installed_rpms = RegistryPoint(no_obfuscate=['ip'])
    interrupts = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ip6tables = RegistryPoint()
    ip6tables_permanent = RegistryPoint(filterable=True)
    ip_addr = RegistryPoint(no_obfuscate=['hostname'])
    ip_addresses = RegistryPoint(no_obfuscate=['hostname'])
    ip_neigh_show = RegistryPoint(no_obfuscate=['hostname'])
    ip_netns_exec_namespace_lsof = RegistryPoint(
        multi_output=True, filterable=True, no_obfuscate=['hostname', 'ip']
    )
    ip_route_show_table_all = RegistryPoint(no_obfuscate=['hostname'])
    ip_s_link = RegistryPoint(no_obfuscate=['hostname'])
    ipa_default_conf = RegistryPoint()
    ipaupgrade_log = RegistryPoint(filterable=True)
    ipcs_m = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ipcs_m_p = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ipcs_s = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ipcs_s_i = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ipsec_conf = RegistryPoint(filterable=True)
    iptables = RegistryPoint()
    iptables_permanent = RegistryPoint(filterable=True)
    ipv4_neigh = RegistryPoint(no_obfuscate=['hostname'])
    ipv6_neigh = RegistryPoint(no_obfuscate=['hostname'])
    iris_cpf = RegistryPoint(multi_output=True)
    iris_list = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    iris_messages_log = RegistryPoint(filterable=True, multi_output=True)
    ironic_conf = RegistryPoint(filterable=True)
    ironic_inspector_log = RegistryPoint(filterable=True)
    iscsiadm_m_session = RegistryPoint()
    jbcs_httpd24_httpd_error_log = RegistryPoint(filterable=True)
    jboss_domain_server_log = RegistryPoint(multi_output=True, filterable=True)
    jboss_runtime_versions = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    jboss_standalone_main_config = RegistryPoint(multi_output=True)
    jboss_standalone_server_log = RegistryPoint(multi_output=True, filterable=True)
    jboss_version = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    journal_all = RegistryPoint(filterable=True)
    journal_header = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    journal_since_boot = RegistryPoint(filterable=True)
    katello_service_status = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    kdump_conf = RegistryPoint()
    kerberos_kdc_log = RegistryPoint(filterable=True)
    kernel_config = RegistryPoint(
        multi_output=True, filterable=True, no_obfuscate=['hostname', 'ip']
    )
    kernel_crash_kexec_post_notifiers = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    kexec_crash_loaded = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    kexec_crash_size = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    keystone_conf = RegistryPoint()
    keystone_crontab = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    keystone_log = RegistryPoint(filterable=True)
    kpatch_list = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    krb5 = RegistryPoint(multi_output=True)
    ksmstate = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ktimer_lockless = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    kubelet_conf = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    kubepods_cpu_quota = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    lastupload = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    ld_library_path_global_conf = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    leapp_migration_results = RegistryPoint()
    leapp_report = RegistryPoint()
    ld_library_path_of_user = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    libssh_client_config = RegistryPoint(filterable=True)
    libssh_server_config = RegistryPoint(filterable=True)
    libvirtd_log = RegistryPoint(filterable=True)
    libvirtd_qemu_log = RegistryPoint(multi_output=True, filterable=True)
    limits_conf = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    locale = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    localectl_status = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    localtime = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    login_pam_conf = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    logrotate_conf = RegistryPoint(multi_output=True)
    losetup = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lpfc_max_luns = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lpstat_p = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lpstat_protocol_printers = RegistryPoint()
    lpstat_queued_jobs_count = RegistryPoint()
    # New `ls` Specs
    ls_la = RegistryPoint()
    ls_la_dirs = RegistryPoint(filterable=True)
    ls_la_filtered = RegistryPoint(filterable=True)
    ls_la_filtered_dirs = RegistryPoint(filterable=True)
    ls_lan = RegistryPoint()
    ls_lan_dirs = RegistryPoint(filterable=True)
    ls_lan_filtered = RegistryPoint(filterable=True)
    ls_lan_filtered_dirs = RegistryPoint(filterable=True)
    ls_lanL = RegistryPoint()
    ls_lanL_dirs = RegistryPoint(filterable=True)
    ls_lanR = RegistryPoint()
    ls_lanR_dirs = RegistryPoint(filterable=True)
    ls_lanRL = RegistryPoint()
    ls_lanRL_dirs = RegistryPoint(filterable=True)
    ls_laRZ = RegistryPoint()
    ls_laRZ_dirs = RegistryPoint(filterable=True)
    ls_laZ = RegistryPoint()
    ls_laZ_dirs = RegistryPoint(filterable=True)
    # Useful individual `ls` Specs
    ls_boot = RegistryPoint()
    ls_dev = RegistryPoint()
    ls_sys_firmware = RegistryPoint()
    # ^ End of ls
    lsattr = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lsattr_files_or_dirs = RegistryPoint(filterable=True)
    lsblk = RegistryPoint()
    lsblk_pairs = RegistryPoint()
    lscpu = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lsinitrd = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    lsinitrd_kdump_image = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    lsinitrd_lvm_conf = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    lsmod = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lsof = RegistryPoint(filterable=True)
    lspci = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lspci_vmmkn = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lssap = RegistryPoint()
    lsscsi = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    luksmeta = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    lvdisplay = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lvm_conf = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    lvm_fullreport = RegistryPoint()
    lvm_system_devices = RegistryPoint(no_obfuscate=['ip'])
    lvmconfig = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lvs_headings = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lvs_noheadings = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    lvs_noheadings_all = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    mac_addresses = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    machine_id = RegistryPoint(no_obfuscate=['hostname', 'ip'], no_redact=True)
    manila_conf = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    mariadb_log = RegistryPoint(filterable=True)
    max_uid = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    md5chk_files = RegistryPoint(multi_output=True)
    mdadm_D = RegistryPoint()
    mdadm_E = RegistryPoint(multi_output=True)
    mdstat = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    meminfo = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    messages = RegistryPoint(filterable=True)
    metadata_json = RegistryPoint(raw=True)
    mistral_executor_log = RegistryPoint(filterable=True)
    mlx4_port = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    modinfo_filtered_modules = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    modinfo_modules = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    modprobe = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    mokutil_sbstate = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    mongod_conf = RegistryPoint(multi_output=True, filterable=True)
    mount = RegistryPoint()
    mountinfo = RegistryPoint()
    mounts = RegistryPoint()
    mpirun_version = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    mssql_api_assessment = RegistryPoint()
    mssql_conf = RegistryPoint()
    mssql_tls_cert_enddate = RegistryPoint()
    multicast_querier = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    multipath__v4__ll = RegistryPoint()
    multipath_conf = RegistryPoint()
    multipath_conf_initramfs = RegistryPoint()
    mysql_log = RegistryPoint(multi_output=True, filterable=True)
    mysqladmin_status = RegistryPoint()
    mysqladmin_vars = RegistryPoint()
    mysqld_limits = RegistryPoint()
    named_checkconf_p = RegistryPoint(filterable=True)
    named_conf = RegistryPoint(filterable=True)
    namespace = RegistryPoint()
    ndctl_list_Ni = RegistryPoint()
    netconsole = RegistryPoint(filterable=True)
    netstat = RegistryPoint()
    netstat_agn = RegistryPoint()
    netstat_i = RegistryPoint()
    netstat_s = RegistryPoint()
    networkmanager_conf = RegistryPoint()
    networkmanager_dispatcher_d = RegistryPoint(multi_output=True)
    neutron_conf = RegistryPoint(filterable=True)
    neutron_dhcp_agent_ini = RegistryPoint(filterable=True)
    neutron_l3_agent_ini = RegistryPoint(filterable=True)
    neutron_l3_agent_log = RegistryPoint(filterable=True)
    neutron_metadata_agent_ini = RegistryPoint(filterable=True)
    neutron_metadata_agent_log = RegistryPoint(filterable=True)
    neutron_ml2_conf = RegistryPoint(filterable=True)
    neutron_ovs_agent_log = RegistryPoint(filterable=True)
    neutron_plugin_ini = RegistryPoint()
    neutron_server_log = RegistryPoint(filterable=True)
    neutron_sriov_agent = RegistryPoint(filterable=True)
    nfnetlink_queue = RegistryPoint()
    nfs_conf = RegistryPoint()
    nfs_exports = RegistryPoint()
    nfs_exports_d = RegistryPoint(multi_output=True)
    nft_list_ruleset = RegistryPoint()
    nginx_conf = RegistryPoint(multi_output=True)
    nginx_error_log = RegistryPoint(filterable=True)
    nginx_ssl_cert_enddate = RegistryPoint(multi_output=True)
    nmap_ssh = RegistryPoint()
    nmcli_conn_show = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    nmcli_dev_show = RegistryPoint()
    nmcli_dev_show_sos = RegistryPoint(multi_output=True)
    nova_api_log = RegistryPoint(filterable=True)
    nova_compute_log = RegistryPoint(filterable=True)
    nova_conf = RegistryPoint()
    nova_crontab = RegistryPoint()
    nova_migration_uid = RegistryPoint()
    nova_uid = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    nscd_conf = RegistryPoint(filterable=True)
    nss_rhel7 = RegistryPoint()
    nsswitch_conf = RegistryPoint(filterable=True)
    ntp_conf = RegistryPoint()
    ntpq_leap = RegistryPoint()
    ntpq_pn = RegistryPoint()
    ntptime = RegistryPoint()
    numa_cpus = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    numeric_user_group_name = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    nvidia_smi_l = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    nvme_core_io_timeout = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    oc_get_bc = RegistryPoint()
    oc_get_build = RegistryPoint()
    oc_get_clusterrole_with_config = RegistryPoint()
    oc_get_clusterrolebinding_with_config = RegistryPoint()
    oc_get_configmap = RegistryPoint()
    oc_get_dc = RegistryPoint()
    oc_get_egressnetworkpolicy = RegistryPoint()
    oc_get_endpoints = RegistryPoint()
    oc_get_event = RegistryPoint()
    oc_get_node = RegistryPoint()
    oc_get_pod = RegistryPoint()
    oc_get_project = RegistryPoint()
    oc_get_pv = RegistryPoint()
    oc_get_pvc = RegistryPoint()
    oc_get_rc = RegistryPoint()
    oc_get_role = RegistryPoint()
    oc_get_rolebinding = RegistryPoint()
    oc_get_route = RegistryPoint()
    oc_get_service = RegistryPoint()
    octavia_conf = RegistryPoint(filterable=True)
    od_cpu_dma_latency = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    odbc_ini = RegistryPoint(filterable=True)
    odbcinst_ini = RegistryPoint()
    open_vm_tools_stat_raw_text_session = RegistryPoint()
    openshift_fluentd_environ = RegistryPoint(multi_output=True)
    openshift_hosts = RegistryPoint(filterable=True)
    openshift_router_environ = RegistryPoint(multi_output=True)
    openvswitch_daemon_log = RegistryPoint(filterable=True)
    openvswitch_other_config = RegistryPoint()
    openvswitch_server_log = RegistryPoint(filterable=True)
    os_release = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    osa_dispatcher_log = RegistryPoint(filterable=True)
    ose_master_config = RegistryPoint()
    ose_node_config = RegistryPoint()
    ovirt_engine_boot_log = RegistryPoint(filterable=True)
    ovirt_engine_confd = RegistryPoint(multi_output=True)
    ovirt_engine_console_log = RegistryPoint(filterable=True)
    ovirt_engine_server_log = RegistryPoint(filterable=True)
    ovirt_engine_ui_log = RegistryPoint(filterable=True)
    ovs_appctl_fdb_show_bridge = RegistryPoint(multi_output=True)
    ovs_ofctl_dump_flows = RegistryPoint(multi_output=True)
    ovs_vsctl_list_bridge = RegistryPoint()
    ovs_vsctl_show = RegistryPoint()
    ovs_vswitchd_limits = RegistryPoint()
    pacemaker_log = RegistryPoint(filterable=True)
    package_provides_command = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    pam_conf = RegistryPoint()
    parted__l = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    partitions = RegistryPoint()
    passenger_status = RegistryPoint()
    password_auth = RegistryPoint()
    pci_rport_target_disk_paths = RegistryPoint()
    pcp_metrics = RegistryPoint()
    pcp_openmetrics_log = RegistryPoint(filterable=True)
    pcp_raw_data = RegistryPoint(
        raw=True, multi_output=True, no_obfuscate=['hostname', 'ip'], no_redact=True
    )  # No Parser required
    pcs_config = RegistryPoint()
    pcs_quorum_status = RegistryPoint()
    pcs_status = RegistryPoint()
    php_ini = RegistryPoint(filterable=True)
    pidstat = RegistryPoint()
    pluginconf_d = RegistryPoint(multi_output=True)
    pmlog_summary = RegistryPoint(
        no_obfuscate=['hostname', 'ip']
    )  # TODO: Remove after 'pcp_raw_data' works
    pmlog_summary_pcp_zeroconf = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    pmrep_metrics = RegistryPoint()
    podman_list_containers = RegistryPoint()
    podman_list_images = RegistryPoint()
    postconf = RegistryPoint(filterable=True)
    postconf_builtin = RegistryPoint(filterable=True)
    postfix_master = RegistryPoint()
    postgresql_conf = RegistryPoint()
    postgresql_log = RegistryPoint(multi_output=True, filterable=True)
    proc_keys = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    proc_keyusers = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    proc_netstat = RegistryPoint()
    proc_slabinfo = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    proc_snmp_ipv4 = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    proc_snmp_ipv6 = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    proc_stat = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ps_alxwww = RegistryPoint(filterable=True)
    ps_aux = RegistryPoint(filterable=True)
    ps_auxcww = RegistryPoint()
    ps_auxww = RegistryPoint(filterable=True)
    ps_ef = RegistryPoint(filterable=True)
    ps_eo = RegistryPoint()
    ps_eo_cmd = RegistryPoint()
    pulp_worker_defaults = RegistryPoint()
    puppet_ca_cert_expire_date = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    puppet_ssl_cert_ca_pem = RegistryPoint()
    puppetserver_config = RegistryPoint(filterable=True)
    pvs_headings = RegistryPoint()
    pvs_noheadings = RegistryPoint()
    pvs_noheadings_all = RegistryPoint()
    qemu_conf = RegistryPoint()
    qemu_xml = RegistryPoint(multi_output=True)
    ql2xmaxlun = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    ql2xmqsupport = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    qpid_stat_g = RegistryPoint()
    qpid_stat_q = RegistryPoint()
    qpid_stat_u = RegistryPoint()
    qpidd_conf = RegistryPoint()
    rabbitmq_env = RegistryPoint()
    rabbitmq_logs = RegistryPoint(multi_output=True, filterable=True)
    rabbitmq_queues = RegistryPoint()
    rabbitmq_startup_err = RegistryPoint(filterable=True)
    rabbitmq_startup_log = RegistryPoint(filterable=True)
    rabbitmq_users = RegistryPoint()
    random_entropy_avail = RegistryPoint()
    rc_local = RegistryPoint()
    rdma_conf = RegistryPoint()
    readlink_e_etc_mtab = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    readlink_e_shift_cert_client = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    readlink_e_shift_cert_server = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    rear_local_conf = RegistryPoint(filterable=True)
    recvq_socket_buffer = RegistryPoint()
    redhat_release = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    repquota_agnpuv = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    resolv_conf = RegistryPoint()
    rhc_conf = RegistryPoint(filterable=True)
    rhev_data_center = RegistryPoint()
    rhn_charsets = RegistryPoint()
    rhn_conf = RegistryPoint()
    rhn_entitlement_cert_xml = RegistryPoint(multi_output=True)
    rhn_hibernate_conf = RegistryPoint()
    rhn_schema_stats = RegistryPoint()
    rhn_schema_version = RegistryPoint()
    rhn_search_daemon_log = RegistryPoint(filterable=True)
    rhn_server_satellite_log = RegistryPoint(filterable=True)
    rhn_server_xmlrpc_log = RegistryPoint(filterable=True)
    rhn_taskomatic_daemon_log = RegistryPoint(filterable=False)
    rhosp_release = RegistryPoint()
    rhsm_conf = RegistryPoint(filterable=True)
    rhsm_katello_default_ca_cert = RegistryPoint()
    rhsm_log = RegistryPoint(filterable=True)
    rhsm_releasever = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    rhui_releasever = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    rhui_set_release = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    rhv_log_collector_analyzer = RegistryPoint()
    rndc_status = RegistryPoint()
    root_crontab = RegistryPoint()
    ros_config = RegistryPoint()  # TODO: Remove after 'pcp_raw_data' works
    route = RegistryPoint()
    rpm_V_package = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    rpm_V_package_list = RegistryPoint(filterable=True)
    rpm_ostree_status = RegistryPoint()
    rpm_pkgs = RegistryPoint(no_obfuscate=['ip'])
    rsyslog_conf = RegistryPoint(filterable=True, multi_output=True)
    rsyslog_tls_ca_cert_enddate = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    rsyslog_tls_cert_enddate = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    samba = RegistryPoint(filterable=True)
    samba_logs = RegistryPoint(multi_output=True, filterable=True)
    sap_dev_disp = RegistryPoint(multi_output=True, filterable=True)
    sap_dev_rd = RegistryPoint(multi_output=True, filterable=True)
    sap_hana_landscape = RegistryPoint(multi_output=True)
    sap_hdb_version = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    sap_host_profile = RegistryPoint(filterable=True)
    sapcontrol_getsystemupdatelist = RegistryPoint()
    saphostctl_getcimobject_sapinstance = RegistryPoint(filterable=True)
    saphostexec_status = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    saphostexec_version = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sat5_insights_properties = RegistryPoint()
    satellite_compute_resources = RegistryPoint()
    satellite_content_hosts_count = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    satellite_core_taskreservedresource_count = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    satellite_custom_ca_chain = RegistryPoint()
    satellite_custom_hiera = RegistryPoint()
    satellite_enabled_features = RegistryPoint()
    satellite_ignore_source_rpms_repos = RegistryPoint()
    satellite_host_facts_count = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    satellite_katello_repos_with_muliple_ref = RegistryPoint()
    satellite_logs_table_size = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    satellite_missed_pulp_agent_queues = RegistryPoint()
    satellite_mongodb_storage_engine = RegistryPoint()
    satellite_non_yum_type_repos = RegistryPoint()
    satellite_provision_param_settings = RegistryPoint()
    satellite_qualified_capsules = RegistryPoint()
    satellite_qualified_katello_repos = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    satellite_revoked_cert_count = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    satellite_rhv_hosts_count = RegistryPoint()
    satellite_sca_status = RegistryPoint()
    satellite_settings = RegistryPoint()
    satellite_version_rb = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    satellite_yaml = RegistryPoint()
    sched_rt_runtime_us = RegistryPoint()
    scheduler = RegistryPoint(multi_output=True)
    scsi = RegistryPoint()
    scsi_eh_deadline = RegistryPoint(multi_output=True)
    scsi_fwver = RegistryPoint(multi_output=True)
    scsi_mod_max_report_luns = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    scsi_mod_use_blk_mq = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sctp_asc = RegistryPoint()
    sctp_eps = RegistryPoint()
    sctp_snmp = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sealert = RegistryPoint()
    secure = RegistryPoint(filterable=True)
    securetty = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    selinux_config = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    selinux_users = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    sendmail_mc = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    sendq_socket_buffer = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sestatus = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    setup_named_chroot = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    smartctl = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    smartpdc_settings = RegistryPoint(filterable=True)
    smbstatus_S = RegistryPoint()
    smbstatus_p = RegistryPoint()
    sockstat = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    softnet_stat = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    software_collections_list = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sos_conf = RegistryPoint(filterable=True)
    spamassassin_channels = RegistryPoint()
    spfile_ora = RegistryPoint(multi_output=True)
    squid_cache_log = RegistryPoint(filterable=True)
    ss = RegistryPoint()
    ssh_config = RegistryPoint(filterable=True)
    ssh_config_d = RegistryPoint(multi_output=True, filterable=True)
    ssh_foreman_config = RegistryPoint(filterable=True)
    ssh_foreman_proxy_config = RegistryPoint(filterable=True)
    sshd_config = RegistryPoint(filterable=True)
    sshd_config_d = RegistryPoint(multi_output=True, filterable=True)
    sshd_config_perms = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sshd_test_mode = RegistryPoint(filterable=True, no_redact=True)
    sssd_config = RegistryPoint()
    sssd_conf_d = RegistryPoint(multi_output=True)
    sssd_logs = RegistryPoint(multi_output=True, filterable=True)
    sys_block_queue_stable_writes = RegistryPoint(multi_output=True)
    subscription_manager_facts = RegistryPoint(filterable=True)
    subscription_manager_id = RegistryPoint(no_obfuscate=['ip'], no_redact=True)
    subscription_manager_installed_product_ids = RegistryPoint(
        filterable=True, no_obfuscate=['hostname', 'ip']
    )
    subscription_manager_list_consumed = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    subscription_manager_list_installed = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    subscription_manager_release_show = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    subscription_manager_status = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sudoers = RegistryPoint(multi_output=True, filterable=True)
    swift_conf = RegistryPoint()
    swift_log = RegistryPoint(filterable=True)
    swift_object_expirer_conf = RegistryPoint()
    swift_proxy_server_conf = RegistryPoint()
    sys_fs_cgroup_memory_tasks_number = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sys_fs_cgroup_uniq_memory_swappiness = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sys_kernel_sched_features = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    sys_vmbus_class_id = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    sys_vmbus_device_id = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    sysconfig_chronyd = RegistryPoint(filterable=True)
    sysconfig_grub = RegistryPoint(filterable=True)
    sysconfig_httpd = RegistryPoint(filterable=True)
    sysconfig_irqbalance = RegistryPoint(filterable=True)
    sysconfig_kdump = RegistryPoint(filterable=True)
    sysconfig_kernel = RegistryPoint(filterable=True)
    sysconfig_libvirt_guests = RegistryPoint(filterable=True)
    sysconfig_memcached = RegistryPoint(filterable=True)
    sysconfig_mongod = RegistryPoint(filterable=True, multi_output=True)
    sysconfig_network = RegistryPoint(filterable=True)
    sysconfig_nfs = RegistryPoint(filterable=True)
    sysconfig_ntpd = RegistryPoint(filterable=True)
    sysconfig_oracleasm = RegistryPoint(filterable=True)
    sysconfig_pcsd = RegistryPoint(filterable=True)
    sysconfig_prelink = RegistryPoint(filterable=True)
    sysconfig_sbd = RegistryPoint(filterable=True)
    sysconfig_sshd = RegistryPoint(filterable=True)
    sysconfig_stonith = RegistryPoint(filterable=True)
    sysconfig_virt_who = RegistryPoint(filterable=True)
    sysctl = RegistryPoint()
    sysctl_conf = RegistryPoint()
    sysctl_conf_initramfs = RegistryPoint(multi_output=True)
    sysctl_d_conf_etc = RegistryPoint(multi_output=True)
    sysctl_d_conf_usr = RegistryPoint(multi_output=True)
    systemctl_cat_dnsmasq_service = RegistryPoint()
    systemctl_cat_rpcbind_socket = RegistryPoint()
    systemctl_get_default = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    systemctl_list_unit_files = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    systemctl_list_units = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    systemctl_show_all_services = RegistryPoint()
    systemctl_show_all_services_with_limited_properties = RegistryPoint()
    systemctl_show_target = RegistryPoint()
    systemctl_status_all = RegistryPoint(filterable=True)
    systemd_analyze_blame = RegistryPoint()
    systemd_docker = RegistryPoint()
    systemd_logind_conf = RegistryPoint()
    systemd_openshift_node = RegistryPoint()
    systemd_system_conf = RegistryPoint()
    systemd_system_origin_accounting = RegistryPoint()
    systemid = RegistryPoint()
    systool_b_scsi_v = RegistryPoint()
    teamdctl_config_dump = RegistryPoint(multi_output=True)
    teamdctl_state_dump = RegistryPoint(multi_output=True)
    testparm_s = RegistryPoint(filterable=True)
    testparm_v_s = RegistryPoint(filterable=True)
    thp_enabled = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    thp_use_zero_page = RegistryPoint()
    timedatectl_status = RegistryPoint()
    tmpfilesd = RegistryPoint(multi_output=True)
    tomcat_server_xml = RegistryPoint(multi_output=True)
    tomcat_vdc_fallback = RegistryPoint()
    tomcat_vdc_targeted = RegistryPoint(multi_output=True)
    tomcat_web_xml = RegistryPoint(multi_output=True)
    tty_console_active = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    tuned_adm = RegistryPoint()
    tuned_conf = RegistryPoint()
    udev_66_md_rules = RegistryPoint(filterable=True)
    udev_fc_wwpn_id_rules = RegistryPoint(filterable=True)
    uname = RegistryPoint(no_obfuscate=['ip'])
    up2date = RegistryPoint(filterable=True)
    up2date_log = RegistryPoint(filterable=True)
    uptime = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    users_count_map_selinux_user = RegistryPoint()
    usr_journald_conf_d = RegistryPoint(multi_output=True)
    var_qemu_xml = RegistryPoint(multi_output=True)
    vdo_status = RegistryPoint()
    vdsm_conf = RegistryPoint()
    vdsm_id = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    vdsm_import_log = RegistryPoint(multi_output=True, filterable=True)
    vdsm_log = RegistryPoint(filterable=True)
    vdsm_logger_conf = RegistryPoint()
    vgdisplay = RegistryPoint()
    vgs_headings = RegistryPoint()
    vgs_noheadings = RegistryPoint()
    vgs_noheadings_all = RegistryPoint()
    vhost_net_zero_copy_tx = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    virsh_list_all = RegistryPoint()
    virt_uuid_facts = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    virt_what = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    virt_who_conf = RegistryPoint(multi_output=True, filterable=True)
    virtlogd_conf = RegistryPoint(filterable=True)
    vma_ra_enabled = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    vmcore_dmesg = RegistryPoint(multi_output=True, filterable=True)
    vmware_tools_conf = RegistryPoint()
    vsftpd = RegistryPoint()
    vsftpd_conf = RegistryPoint(filterable=True)
    watchdog_logs = RegistryPoint(filterable=True, multi_output=True)
    wc_proc_1_mountinfo = RegistryPoint()
    x86_ibpb_enabled = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    x86_ibrs_enabled = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    x86_pti_enabled = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    x86_retp_enabled = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    xfs_info = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    xfs_quota_state = RegistryPoint(no_obfuscate=['hostname', 'ip'])
    xinetd_conf = RegistryPoint(multi_output=True)
    yum_conf = RegistryPoint(filterable=True)
    yum_list_available = RegistryPoint(no_obfuscate=['ip'])
    yum_list_installed = RegistryPoint(no_obfuscate=['ip'])
    yum_log = RegistryPoint(filterable=True, no_obfuscate=['ip'])
    yum_repolist = RegistryPoint()
    yum_repos_d = RegistryPoint(multi_output=True)
    yum_updateinfo = RegistryPoint(no_obfuscate=['ip'])
    yum_updates = RegistryPoint(no_obfuscate=['ip'])
    zdump_v = RegistryPoint()
    zipl_conf = RegistryPoint()

    # container_specs
    container_cpu_online = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    container_cpuset_cpus = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    container_dotnet_version = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    container_installed_rpms = RegistryPoint(multi_output=True, no_obfuscate=['ip'])
    container_inspect_keys = RegistryPoint(filterable=True, no_obfuscate=['hostname', 'ip'])
    container_mssql_api_assessment = RegistryPoint(multi_output=True)
    container_nginx_conf = RegistryPoint(multi_output=True)
    container_nginx_error_log = RegistryPoint(multi_output=True, filterable=True)
    container_ps_aux = RegistryPoint(multi_output=True, filterable=True)
    container_redhat_release = RegistryPoint(multi_output=True, no_obfuscate=['hostname', 'ip'])
    container_vsftpd_conf = RegistryPoint(multi_output=True, filterable=True)
    containers_inspect = RegistryPoint(no_obfuscate=['hostname', 'ip'])
